/*****************************************************************************
*  LPC11U6x Center Aligned demo program
*
*  1. Use SCT0 timer to generate a center aligned PWM output signal @ SCT1_OUT0
*  2. Every time SW1 goes high to low increase the duty cycle
*  3. Every time SW2 goes high to low decrease the duty cycle
*  4. SCT1_OUT0 is connected to P2_16
*****************************************************************************/
#include "board.h"

void SCT1_Init(void);

void SCT1_Init(void)
{

	Chip_SCT_Init(LPC_SCT1);							   						//enable clock for SCT0/1

	Chip_SCT_Config(LPC_SCT1,  SCT_CONFIG_AUTOLIMIT_L);							//two 16-bit timers, clocked internally, auto limit


	Chip_SCT_SetControl(LPC_SCT1, SCT_CTRL_BIDIR_L(1)|
								  SCT_CTRL_PRE_L(5)	);							// Bidir mode, prescaler = 6, SCT clock = 2 MHz

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_0,9);					   		// match 0 @ 10/2MHz = 5 usec (100 KHz PWM freq)
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_0, 9);

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_1,5);					   		// match 1 used for duty cycle (in 10 steps)
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_1, 5);


	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_0, ENABLE_ALL_STATES);				// event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH1	|			// related to match 1
                                                                        SCT_COMBMODE_MATCH	));			// COMBMODE[13:12] = match condition only



	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_0 , SCT_EVT_0);					// event 0 will clear SCT_OUT0

	Chip_SCT_SetoutputdirControl(LPC_SCT1, SCT_EVT_0);							// reverse output 0 set when down counting

	Chip_SCT_ClearControl(LPC_SCT1, SCT_CTRL_HALT_L);							// unhalt it by clearing bit 2 of the CTRL register
}



int main (void) 
{

	static uint8_t trg1 = 1;
	static uint8_t trg2 = 1;


	SystemCoreClockUpdate();
	Board_Init();


	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);				// enable clock for IOCON


	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,16 , 0x00000081);				// P2_16 is SCT0_OUT0

	SCT1_Init();                                   					// Initialize SCT


	while (1)                                              			// loop forever
	{
		if (!Chip_GPIO_GetPinState(LPC_GPIO, 0, 16) && trg1)    	// SW1 high to low?
		{
			trg1 = 0;                                      			// trigger SW1 low
			if (LPC_SCT1->MATCHREL[1].L < 19)
				LPC_SCT1->MATCHREL[1].L ++;                			// increase PWM duty cycle
		}
		else if (Chip_GPIO_GetPinState(LPC_GPIO, 0, 16) && !trg1)	// SW1 low to high?
		{
			trg1 = 1;                                      			// trigger SW1 high
		}

		if (!Chip_GPIO_GetPinState(LPC_GPIO, 0, 1) && trg2)         // SW2 high to low?
		{
			trg2 = 0;                                      			// trigger SW2 low
			if (LPC_SCT1->MATCHREL[1].L > 0)
				LPC_SCT1->MATCHREL[1].L --;                			// decrease PWM duty cycle
		}
		else if (Chip_GPIO_GetPinState(LPC_GPIO, 0, 1) && !trg2)    // SW2 low to high?
		{
			trg2 = 1;                                      			// trigger P0.1 high
		}
	}
}

